<?php
require __DIR__ . '/../api/helpers.php';
auth_start();
if (empty($_SESSION['admin_id'])) { header('Location: /admin/login.php'); exit; }
?><!doctype html>
<html lang="nl">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Hairdate Admin</title>
<link rel="stylesheet" href="/public/styles.css">
</head>
<body class="bg">
<header class="topbar glass">
  <div class="brand">Hairdate Admin</div>
  <nav>
    <a href="#" data-tab="agenda" class="active">Agenda</a>
    <a href="#" data-tab="services">Behandelingen</a>
    <a href="#" data-tab="hours">Openingstijden</a>
    <a href="#" data-tab="customers">Klanten</a>
    <a href="/admin/logout.php">Uitloggen</a>
  </nav>
</header>
<main class="container">
  <section id="tab-agenda" class="tab active glass">
    <h2>Agenda</h2>
    <div class="row">
      <input type="date" id="agendaDate">
      <button id="refreshAgenda">Vernieuwen</button>
    </div>
    <div id="agendaList" class="list"></div>
  </section>

  <section id="tab-services" class="tab glass">
    <h2>Behandelingen</h2>
    <div class="row">
      <input id="svcName" placeholder="Naam (bijv. Verven vrouwen)">
      <input id="svcDur" type="number" min="5" step="5" placeholder="Duur (min)">
      <button id="svcAdd">Toevoegen</button>
    </div>
    <div id="svcList" class="list"></div>
  </section>

  <section id="tab-hours" class="tab glass">
    <h2>Openingstijden</h2>
    <div id="hoursList" class="list"></div>
    <button id="hoursSave">Opslaan</button>
  </section>

  <section id="tab-customers" class="tab glass">
    <h2>Klanten</h2>
    <input id="custSearch" placeholder="Zoek naam of e-mail">
    <div id="custList" class="list"></div>
    <div class="row">
      <input id="emailSummary" placeholder="E-mail klant">
      <button id="sendSummary">Stuur overzicht per e-mail</button>
    </div>
  </section>
</main>

<script src="/public/app.js"></script>
<script>
// Tabs
document.querySelectorAll('nav a[data-tab]').forEach(a=>{
  a.addEventListener('click', (e)=>{
    e.preventDefault();
    document.querySelector('nav a.active').classList.remove('active');
    a.classList.add('active');
    document.querySelectorAll('.tab').forEach(t=>t.classList.remove('active'));
    document.getElementById('tab-'+a.dataset.tab).classList.add('active');
  });
});
</script>
</body></html>
