<?php
require __DIR__ . "/helpers.php";
$pdo = db();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $data = json_decode(file_get_contents('php://input'), true);
  $email = trim($data['email'] ?? '');
  $pass = $data['password'] ?? '';
  $stmt = $pdo->prepare("SELECT id, password_hash FROM users WHERE email=?");
  $stmt->execute([$email]);
  $u = $stmt->fetch();
  if (!$u || !password_verify($pass, $u['password_hash'])) {
    json_response(['error' => 'Invalid credentials'], 401);
  }
  auth_start();
  $_SESSION['admin_id'] = $u['id'];
  json_response(['ok' => true]);
}

if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
  auth_start();
  session_destroy();
  json_response(['ok' => true]);
}

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
  auth_start();
  json_response(['authenticated' => !empty($_SESSION['admin_id'])]);
}
