<?php
require __DIR__ . '/helpers.php';
$pdo = db();

// GET /api/availability.php?date=YYYY-MM-DD&service_id=1
require_method('GET');
$date = $_GET['date'] ?? '';
$service_id = intval($_GET['service_id'] ?? 0);

if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $date) || $service_id<=0) {
  json_response(['error' => 'Invalid parameters'], 400);
}

# fetch duration for the service
$dur = (int)($pdo->query("SELECT duration_minutes FROM appointment_types WHERE id={$service_id}")->fetch()['duration_minutes'] ?? 0);
if ($dur<=0) json_response(['error' => 'Unknown service'], 404);

$weekday = (new DateTime($date))->format('w'); // 0 (Sun) - 6 (Sat)
$wh = $pdo->prepare("SELECT open_time, close_time, is_closed FROM working_hours WHERE weekday=?");
$wh->execute([$weekday]);
$row = $wh->fetch();
if (!$row || intval($row['is_closed']) === 1) {
  json_response(['slots' => []]);
}
$open = new DateTime("{$date} {$row['open_time']}");
$close = new DateTime("{$date} {$row['close_time']}");

# existing appointments on that day
$apps = $pdo->prepare("SELECT start_time, end_time FROM appointments WHERE DATE(start_time)=? AND status IN ('confirmed','pending') ORDER BY start_time");
$apps->execute([$date]);
$busy = [];
foreach ($apps as $a) {
  $busy[] = [new DateTime($a['start_time']), new DateTime($a['end_time'])];
}

# build 15-min grid from open to last possible start
$slots = [];
$cursor = clone $open;
$interval = new DateInterval('PT15M');
while ($cursor <= (clone $close)->sub(new DateInterval('PT' . $dur . 'M'))) {
  $start = clone $cursor;
  $end = (clone $start)->add(new DateInterval('PT' . $dur . 'M'));

  $overlap = false;
  foreach ($busy as [$bstart, $bend]) {
    if ($start < $bend && $end > $bstart) { $overlap = true; break; }
  }
  if (!$overlap) {
    $slots[] = ['start' => $start->format('H:i'), 'end' => $end->format('H:i')];
  }
  $cursor->add($interval);
}

json_response(['slots' => $slots]);
