<?php
// helpers.php
$config = require __DIR__ . '/../config.php';
date_default_timezone_set($config['app']['timezone'] ?? 'Europe/Amsterdam');

function db() {
  static $pdo = null;
  if ($pdo) return $pdo;
  $cfg = require __DIR__ . '/../config.php';
  $dsn = "mysql:host={$cfg['db']['host']};dbname={$cfg['db']['name']};charset={$cfg['db']['charset']}";
  $options = [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES => false,
  ];
  $pdo = new PDO($dsn, $cfg['db']['user'], $cfg['db']['pass'], $options);
  return $pdo;
}

function json_response($data, $code = 200) {
  http_response_code($code);
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode($data);
  exit;
}

function require_method($method) {
  if ($_SERVER['REQUEST_METHOD'] !== $method) {
    json_response(['error' => 'Method not allowed'], 405);
  }
}

function sanitize($str) {
  return htmlspecialchars($str, ENT_QUOTES, 'UTF-8');
}

function auth_start() {
  $cfg = require __DIR__ . '/../config.php';
  if (session_status() !== PHP_SESSION_ACTIVE) {
    session_name($cfg['security']['session_name']);
    session_start();
  }
}

function ensure_admin() {
  auth_start();
  if (empty($_SESSION['admin_id'])) {
    json_response(['error' => 'Unauthorized'], 401);
  }
}
