<?php
require __DIR__ . "/helpers.php";
$pdo = db();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
  $stmt = $pdo->query("SELECT weekday, open_time, close_time, is_closed FROM working_hours ORDER BY weekday");
  json_response($stmt->fetchAll());
}

if ($_SERVER['REQUEST_METHOD'] === 'PUT' || $_SERVER['REQUEST_METHOD'] === 'POST') {
  ensure_admin();
  $data = json_decode(file_get_contents('php://input'), true);
  $rows = $data['rows'] ?? [];
  $pdo->beginTransaction();
  $stmt = $pdo->prepare("UPDATE working_hours SET open_time=?, close_time=?, is_closed=? WHERE weekday=?");
  foreach ($rows as $r) {
    $weekday = intval($r['weekday']);
    $open = $r['open_time'];
    $close = $r['close_time'];
    $closed = intval($r['is_closed'] ?? 0);
    $stmt->execute([$open, $close, $closed, $weekday]);
  }
  $pdo->commit();
  json_response(['ok' => true]);
}
