# Hairdate Booking (Standalone PHP)
A lightweight, modern, glass-style booking system for hair salons. Works on standard cPanel (PHP 8+, MySQL/MariaDB).

## Features
- Public booking UI with live availability per day and service
- Variable service durations (e.g., 30–180 minutes)
- Prevents overlapping bookings
- Admin agenda (create/modify/cancel bookings)
- Manage appointment types (name + duration)
- Working hours per weekday
- Customer list and email a summary of all their bookings
- No payments
- Embeddable in Elementor via `<iframe>` (subdomain ready)

## Quick start (cPanel)
1. **Create database** (already created per your message): ensure you know: host, db name, user, pass.
2. **Upload files** to a subdomain folder, e.g. `booking.yourdomain.com` or `/public_html/booking`.
3. **Copy** `config.sample.php` to `config.php` and fill your DB credentials. **Do not commit real passwords.**
4. In **phpMyAdmin**, **import** `migrate.sql`. This creates tables and seed data.
5. Visit `/admin` to set opening hours and add services. Default admin login:
   - Email: `owner@local`
   - Password: `changeme123`
   Change it immediately in Admin → Settings.
6. To embed in WordPress/Elementor, add an **HTML widget** with:
   ```html
   <iframe src="https://booking.yourdomain.com/" style="width:100%;min-height:900px;border:0;border-radius:16px;overflow:hidden;"></iframe>
   ```

## Requirements
- PHP 8.0+ with PDO MySQL
- MySQL/MariaDB 10.3+
- `mbstring`, `openssl` enabled for password hashing/email

## Structure
```
/
  api/
    appointments.php
    services.php
    availability.php
    customers.php
    working_hours.php
    admin_auth.php
    email_summary.php
  admin/
    index.php
    login.php
    logout.php
  public/
    index.php
    styles.css
    app.js
  config.sample.php
  config.php (create from sample)
  migrate.sql
  README.md
```

## Notes
- Email uses PHP `mail()` by default. Configure SPF/DKIM and "Additional headers" in `config.php` for reliable delivery, or switch to SMTP if desired.
- Timezone defaults to `Europe/Amsterdam`. Adjust in `config.php` if needed.
