<?php
require __DIR__ . '/helpers.php';
$pdo = db();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
  // optional: ?date=YYYY-MM-DD
  $date = $_GET['date'] ?? null;
  if ($date) {
    $stmt = $pdo->prepare("SELECT a.id, a.start_time, a.end_time, a.status, c.full_name, c.email, t.name AS service
                           FROM appointments a
                           JOIN customers c ON c.id=a.customer_id
                           JOIN appointment_types t ON t.id=a.appointment_type_id
                           WHERE DATE(a.start_time)=?
                           ORDER BY a.start_time");
    $stmt->execute([$date]);
  } else {
    $stmt = $pdo->query("SELECT a.id, a.start_time, a.end_time, a.status, c.full_name, c.email, t.name AS service
                         FROM appointments a
                         JOIN customers c ON c.id=a.customer_id
                         JOIN appointment_types t ON t.id=a.appointment_type_id
                         ORDER BY a.start_time DESC LIMIT 200");
  }
  json_response($stmt->fetchAll());
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  // create appointment (public or admin)
  $data = json_decode(file_get_contents('php://input'), true);
  $name = trim($data['full_name'] ?? '');
  $email = trim($data['email'] ?? '');
  $service_id = intval($data['service_id'] ?? 0);
  $date = $data['date'] ?? '';
  $time = $data['time'] ?? '';
  $notes = trim($data['notes'] ?? '');

  if ($name==='' || !filter_var($email, FILTER_VALIDATE_EMAIL) || $service_id<=0 ||
      !preg_match('/^\d{4}-\d{2}-\d{2}$/', $date) || !preg_match('/^\d{2}:\d{2}$/', $time)) {
    json_response(['error' => 'Invalid input'], 400);
  }

  $dur = (int)($pdo->query("SELECT duration_minutes FROM appointment_types WHERE id={$service_id}")->fetch()['duration_minutes'] ?? 0);
  if ($dur<=0) json_response(['error' => 'Unknown service'], 400);

  $start = new DateTime("{$date} {$time}");
  $end = (clone $start)->add(new DateInterval('PT' . $dur . 'M'));

  // Ensure customer exists
  $stmt = $pdo->prepare("SELECT id FROM customers WHERE email=?");
  $stmt->execute([$email]);
  $cust = $stmt->fetch();
  if ($cust) { $customer_id = $cust['id']; }
  else {
    $pdo->prepare("INSERT INTO customers (full_name, email) VALUES (?,?)")->execute([$name, $email]);
    $customer_id = $pdo->lastInsertId();
  }

  // Check overlap
  $chk = $pdo->prepare("SELECT COUNT(*) cnt FROM appointments WHERE DATE(start_time)=? AND status IN ('confirmed','pending')
                         AND ((start_time < ? AND end_time > ?) OR (start_time >= ? AND start_time < ?))");
  $chk->execute([$date, $end->format('Y-m-d H:i:s'), $start->format('Y-m-d H:i:s'), $start->format('Y-m-d H:i:s'), $end->format('Y-m-d H:i:s')]);
  if ((int)$chk->fetch()['cnt'] > 0) {
    json_response(['error' => 'Slot no longer available'], 409);
  }

  $stmt = $pdo->prepare("INSERT INTO appointments (customer_id, appointment_type_id, start_time, end_time, status, notes) VALUES (?,?,?,?,?,?)");
  $stmt->execute([$customer_id, $service_id, $start->format('Y-m-d H:i:s'), $end->format('Y-m-d H:i:s'), 'confirmed', $notes]);

  json_response(['ok' => true, 'id' => $pdo->lastInsertId()]);
}

if ($_SERVER['REQUEST_METHOD'] === 'PUT') {
  ensure_admin();
  parse_str($_SERVER['QUERY_STRING'] ?? '', $qs);
  $id = intval($qs['id'] ?? 0);
  $data = json_decode(file_get_contents('php://input'), true);
  if ($id<=0) json_response(['error' => 'Invalid id'], 400);

  $fields = [];
  $values = [];

  if (isset($data['start_time'])) { $fields[] = 'start_time=?'; $values[] = $data['start_time']; }
  if (isset($data['end_time'])) { $fields[] = 'end_time=?'; $values[] = $data['end_time']; }
  if (isset($data['status'])) { $fields[] = 'status=?'; $values[] = $data['status']; }
  if (isset($data['notes'])) { $fields[] = 'notes=?'; $values[] = $data['notes']; }
  if (!$fields) json_response(['error' => 'No fields'], 400);
  $values[] = $id;

  $sql = "UPDATE appointments SET " . implode(',', $fields) . " WHERE id=?";
  $pdo->prepare($sql)->execute($values);
  json_response(['ok' => true]);
}

if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
  ensure_admin();
  parse_str($_SERVER['QUERY_STRING'] ?? '', $qs);
  $id = intval($qs['id'] ?? 0);
  if ($id<=0) json_response(['error' => 'Invalid id'], 400);
  $pdo->prepare("DELETE FROM appointments WHERE id=?")->execute([$id]);
  json_response(['ok' => true]);
}
