<?php
require __DIR__ . "/helpers.php";
$pdo = db();
$cfg = require __DIR__ . '/../config.php';

require_method('POST');
ensure_admin();

$data = json_decode(file_get_contents('php://input'), true);
$email = trim($data['email'] ?? '');
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) json_response(['error' => 'Invalid email'], 400);

$stmt = $pdo->prepare("SELECT full_name FROM customers WHERE email=?");
$stmt->execute([$email]);
$c = $stmt->fetch();
if (!$c) json_response(['error' => 'Unknown customer'], 404);

$apps = $pdo->prepare("SELECT a.start_time, a.end_time, t.name AS service
                       FROM appointments a
                       JOIN appointment_types t ON t.id=a.appointment_type_id
                       JOIN customers c ON c.id=a.customer_id
                       WHERE c.email=? AND a.status IN ('confirmed','pending')
                       ORDER BY a.start_time");
$apps->execute([$email]);
$lines = [];
foreach ($apps as $a) {
  $lines[] = sprintf("- %s → %s (%s)",
    (new DateTime($a['start_time']))->format('d-m-Y H:i'),
    (new DateTime($a['end_time']))->format('H:i'),
    $a['service']
  );
}
$body = "Beste {$c['full_name']},\n\nHier is een overzicht van uw afspraken:\n\n" . implode("\n", $lines) . "\n\nGroeten,\nHairdate";

$headers = 'From: ' . $cfg['mail']['from'] . "\r\n" . ($cfg['mail']['headers'] ?? '');
@mail($email, 'Overzicht afspraken', $body, $headers);
json_response(['ok' => true, 'sent' => true]);
