<?php
require __DIR__ . '/helpers.php';
$pdo = db();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
  $stmt = $pdo->query("SELECT id, name, duration_minutes FROM appointment_types ORDER BY name");
  json_response($stmt->fetchAll());
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  ensure_admin();
  $data = json_decode(file_get_contents('php://input'), true);
  $name = trim($data['name'] ?? '');
  $dur = intval($data['duration_minutes'] ?? 0);
  if ($name === '' || $dur <= 0) json_response(['error' => 'Invalid input'], 400);
  $stmt = $pdo->prepare("INSERT INTO appointment_types (name, duration_minutes) VALUES (?,?)");
  $stmt->execute([$name, $dur]);
  json_response(['ok' => true, 'id' => $pdo->lastInsertId()]);
}

if ($_SERVER['REQUEST_METHOD'] === 'PUT') {
  ensure_admin();
  parse_str($_SERVER['QUERY_STRING'] ?? '', $qs);
  $id = intval($qs['id'] ?? 0);
  $data = json_decode(file_get_contents('php://input'), true);
  $name = trim($data['name'] ?? '');
  $dur = intval($data['duration_minutes'] ?? 0);
  if ($id<=0 || $name === '' || $dur <= 0) json_response(['error' => 'Invalid input'], 400);
  $stmt = $pdo->prepare("UPDATE appointment_types SET name=?, duration_minutes=? WHERE id=?");
  $stmt->execute([$name, $dur, $id]);
  json_response(['ok' => true]);
}

if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
  ensure_admin();
  parse_str($_SERVER['QUERY_STRING'] ?? '', $qs);
  $id = intval($qs['id'] ?? 0);
  if ($id<=0) json_response(['error' => 'Invalid id'], 400);
  $pdo->prepare("DELETE FROM appointment_types WHERE id=?")->execute([$id]);
  json_response(['ok' => true]);
}
