<?php
// Copy this file to config.php and fill in your credentials.
// Never commit real secrets to version control.

return [
  'db' => [
    'host' => getenv('DB_HOST') ?: 'localhost',
    'name' => getenv('DB_NAME') ?: 'hairdate_saloonmngr',
    'user' => getenv('DB_USER') ?: 'hairdate_slnmngrusr',
    'pass' => getenv('DB_PASS') ?: '',
    'charset' => 'utf8mb4',
  ],
  'app' => [
    'base_url' => '', // e.g. 'https://booking.yourdomain.com' (optional)
    'timezone' => 'Europe/Amsterdam',
  ],
  'mail' => [
    'from' => 'no-reply@yourdomain.com',
    'from_name' => 'Hairdate Booking',
    'headers' => 'Content-Type: text/plain; charset=UTF-8',
    // To use SMTP, you could integrate a library like PHPMailer here.
  ],
  'security' => [
    'session_name' => 'hairdate_session',
    'jwt_secret' => bin2hex(random_bytes(16)),
  ]
];
