-- migrate.sql
CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  email VARCHAR(190) UNIQUE NOT NULL,
  password_hash VARCHAR(255) NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS appointment_types (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(190) NOT NULL,
  duration_minutes INT NOT NULL CHECK (duration_minutes > 0)
);

CREATE TABLE IF NOT EXISTS customers (
  id INT AUTO_INCREMENT PRIMARY KEY,
  full_name VARCHAR(190) NOT NULL,
  email VARCHAR(190) UNIQUE NOT NULL,
  phone VARCHAR(50) DEFAULT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS appointments (
  id INT AUTO_INCREMENT PRIMARY KEY,
  customer_id INT NOT NULL,
  appointment_type_id INT NOT NULL,
  start_time DATETIME NOT NULL,
  end_time DATETIME NOT NULL,
  status ENUM('pending','confirmed','cancelled') DEFAULT 'confirmed',
  notes TEXT,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (customer_id) REFERENCES customers(id) ON DELETE CASCADE,
  FOREIGN KEY (appointment_type_id) REFERENCES appointment_types(id) ON DELETE RESTRICT,
  INDEX (start_time), INDEX (end_time)
);

CREATE TABLE IF NOT EXISTS working_hours (
  weekday TINYINT NOT NULL PRIMARY KEY, -- 0=Sun..6=Sat
  open_time TIME NOT NULL DEFAULT '09:00:00',
  close_time TIME NOT NULL DEFAULT '18:00:00',
  is_closed TINYINT(1) NOT NULL DEFAULT 0
);

-- seed working hours for all days if empty
INSERT INTO working_hours (weekday, open_time, close_time, is_closed) 
SELECT d, '09:00:00', '18:00:00', CASE WHEN d IN (0) THEN 1 ELSE 0 END
FROM (SELECT 0 d UNION ALL SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 3 UNION ALL SELECT 4 UNION ALL SELECT 5 UNION ALL SELECT 6) x
WHERE NOT EXISTS (SELECT 1 FROM working_hours);

-- seed admin user (password: changeme123)
INSERT IGNORE INTO users (email, password_hash) VALUES
('owner@local', '$2y$10$E2AqdeJb1C1m7YF.PwyVme4gR0c5l2vWZz2p6rYd0r9cT5uGk7v2y'); -- bcrypt for 'changeme123'

-- sample services
INSERT INTO appointment_types (name, duration_minutes)
SELECT * FROM (SELECT 'Knippen dames' AS n, 45 AS m) a
WHERE NOT EXISTS (SELECT 1 FROM appointment_types);
INSERT INTO appointment_types (name, duration_minutes) VALUES ('Verven vrouwen', 90), ('Wassen & föhnen', 30);
